dialog -l ffta {
  title "FFTA Clan Abilities Manager v2.2"
  size -1 -1 168 120
  option dbu
  text "Clan Member:", 1, 8 14 33 7, right
  text "Race:", 2, 8 27 33 7, right
  text "Job:", 3, 5 43 11 7, right
  text "Ability:", 4, 8 64 17 7, right
  combo 5, 44 13 60 40, size drop
  button "Add", 6, 107 13 25 10
  button "Remove", 7, 135 13 25 10
  button "Rename", 8, 107 26 25 10
  button "Reorder", 9, 135 26 25 10
  edit "", 10, 44 26 60 10, read
  combo 11, 19 42 60 40, size drop
  combo 16, 28 63 60 40, size drop
  check "Learning", 14, 8 78 32 7
  text "AP:", 15, 46 85 9 7
  edit "", 18, 58 84 17 10, limit 3 right
  text "/", 19, 76 85 2 7
  edit "", 20, 79 84 17 10, read right
  check "Mastered", 17, 8 88 32 7
  button "Close", 22, 24 105 30 10, default cancel
  button "View Report", 23, 59 105 35 10
  button "Make HTML Page", 24, 99 105 45 10
  list 25, 0 0 0 0, hide size
  box "Clan Members", 26, 5 5 158 34
  box "Learning", 12, 43 76 56 21
  box "Ability Management", 13, 5 55 97 45
}
alias -l fftadir {
  if (!$var(%fftatmp.scriptdir, 0)) set -u300 %fftatmp.scriptdir $scriptdir
  return %fftatmp.scriptdir
}
alias ffta {
  dialog -m ffta.start-wait ffta.start-wait
  .timer 1 1 ffta.initini
}
alias -l ffta.putini {
  writeini -n " $+ $fftadir $+ ffta.ini" $$1 $$2 $$3
  dll " $+ $fftadir $+ cbxini.dll" updateindex $fftadir $+ ffta.ini
}
alias -l ffta.getini {
  var %data = $dll(" $+ $fftadir $+ cbxini.dll", readini, $$1 $$2 $fftadir $+ ffta.ini)
  %data = $iif(%data, %data, $readini(" $+ $fftadir $+ ffta.ini", n, $$1, $$2))
  return $iif(%data, %data, )
}
alias -l ffta.remini {
  remini " $+ $fftadir $+ ffta.ini" $$1 $2
  dll " $+ $fftadir $+ cbxini.dll" updateindex $fftadir $+ ffta.ini
}
alias -l ffta.getabilnum {
  var %job = $$1, %ability = $$2, %x = 0, %abilnum, %abils = $ffta.getini(%job, Abilities)
  if (%abils == ) %abils = 0
  while (%x <= %abils) {
    var %abil = $gettok($ffta.getini(%job, Ability $+ %x), 1, 127)
    if (%abil == %ability) { %abilnum = %x | break }
    inc %x
  }
  return %abilnum
}
dialog -l ffta.start-wait {
  title "Please Wait..."
  size -1 -1 65 33
  option dbu
  text "Please wait while your", 1, 5 5 55 7, center
  text "ffta.ini is checked and", 2, 5 13 55 7, center
  text "updated, if nessacary.", 3, 5 21 55 7, center
  button "", 4, 0 0 0 0, hide disable ok
}
alias -l ffta.jobsstr {
  var %race = $$1, %jobs
  if (%race == Human) %jobs = Soldier|Paladin|Fighter|Thief|Ninja|WhiteMage|BlackMage|Illusionist|BlueMage|Archer|Hunter
  if (%race == Moogle) %jobs = Animist|MogKnight|Gunner|Thief|Juggler|Gadgeteer|BlackMage|TimeMage
  if (%race == Viera) %jobs = Fencer|Elementalist|RedMage|WhiteMage|Summoner|Archer|Assassin|Sniper
  if (%race == NuMou) %jobs = WhiteMage|BlackMage|TimeMage|Illusionist|Alchemist|Beastmaster|Morpher|Sage
  if (%race == Bangaa) %jobs = Warrior|Dragoon|Defender|Gladiator|WhiteMonk|Bishop|Templar
  return %jobs
}
alias -l ffta.abilsstr {
  var %job = $$1, %abilities
  if (%job == Soldier) %abilities = FirstAid100|Powerbreak200|Mindbreak200|Magicbreak200|Speedbreak200|Mug300|Provoke300|Sensor300|MonkeyGrip300|Shieldbearer300|CombatCombo100
  if (%job == Paladin) %abilities = Nurse100|Defense200|Cover200|Subdue200|DropWeapon200|Parley200|SaintCross300|HolyBlade300|Reflex300|WeaponDef+300|KnightCombo100
  if (%job == Fighter) %abilities = Rush100|WildSwing200|Beatdown200|Blitz200|AirRender200|FarFist200|AirBlast300|Backdraft300|Bonecrusher300|Strikeback300|Doublehand300|FightCombo100
  if (%job == Thief) %abilities = Steal:Armor300|Steal:Shield200|Steal:Access.300|Steal:Helm300|Steal:Weapon300|Steal:Gil100|Steal:EXP100|Steal:JP200|Steal:Ability300|Counter300|Maintenance300|ThiefCombo100
  if (%job == Ninja) %abilities = Throw100|WoodVeil200|FireVeil200|EarthVeil200|MetalVeil200|WaterVeil200|Unspell300|Oblivion300|LastHaste300|DoubleSword999|NinjaCombo100
  if (%job == WhiteMage) %abilities = Cure100|Cura200|Curaga300|Esuna200|Life200|Full-Life300|Auto-Life200|Shell100|Protect100|TurboMP300|WhiteCombo100
  if (%job == BlackMage) %abilities = Fire100|Fira200|Firaga300|Thunder100|Thundara200|Thundaga300|Blizzard100|Blizzara200|Blizzaga300|ReturnMagic300|Geomancy300|BlackCombo100
  if (%job == Illusionist) %abilities = Prominence100|Tempest100|Freezeblink100|StarCross300|Stardust300|Deluge200|SoilEvidence200|WildTornado200|AbsorbMP300|HalfMP300|SpellCombo100
  if (%job == BlueMage) %abilities = GoblinPunch0|MagicHammer0|Acid0|Blowup0|MightyGuard0|Guard-Off0|DragonForce0|Night0|Twister0|LV3Def-less0|MatraMagic0|PoisonClaw0|Hastebreak0|BadBreath0|Stare0|Roulette0|DrainTouch0|LV?S-Flare0|WhiteWind0|AngelWhisper0|Damage>MP300|Immunity300|Learning400|BlueCombo100
  if (%job == Archer) %abilities = Boost100|Aim:Legs200|Aim:Arm200|Cupid200|Burial300|TakeAim300|Faster300|Blackout200|BlockArrows300|Concentrate300|BowCombo100
  if (%job == Hunter) %abilities = SonicBoom200|Oust200|Advice100|Aim:Vitals300|Hunting300|Addle200|UltimaShot999|Sidewinder300|Capture200|Auto-Regen300|WeaponAtk+300|HuntCombo100
  if (%job == Animist) %abilities = SheepCount100|100%Wool200|Cuisine300|TailWag200|ChocoboRush300|Frogsong200|Friend300|Catnip100|BlockArrows300|AnimalCombo100
  if (%job == MogKnight) %abilities = MogAttack100|MogGuard200|MogLance200|MogRush200|MogShield300|MogPeek300|MogAid300|UltimaCharge999|LastHaste300|Shieldbearer300|ChargeCombo100
  if (%job == Gunner) %abilities = Fireshot100|Boltshot100|Iceshot100|Confushot200|Charmshot300|Blindshot100|Silenshot200|Stopshot300|Concentrate300|GunCombo100
  if (%job == Juggler) %abilities = Hurl100|Ring200|Firebomb300|Ball200|Dagger300|Smile300|GilToss100|Catch300|ReturnFire300|JuggleCombo100
  if (%job == Gadgeteer) %abilities = RedSpring200|BlueScrew200|GreenGear200|SilverDisc200|GoldBattery200|BlackIngot200|ChromaGem200|YellowSpring200|Auto-Regen300|Damage>MP300|GadgetCombo100
  if (%job == TimeMage) %abilities = Haste200|Quicken300|Slow200|Reflect300|Stop300|Silence200|Quarter200|Demi300|LastQuicken300|TimeCombo100
  if (%job == Fencer) %abilities = Swarmstrike100|Shadowstick200|Checkmate300|Featherblow200|Swallowtail300|Manastrike300|Piercethrough200|Nighthawk200|Reflex300|Shieldbearer300|LungeCombo100
  if (%job == Elementalist) %abilities = FireWhip100|EarthHeal200|WhiteFlame100|ShiningAir200|EvilGaze300|HeavyDust200|Sliprain200|Elementalshift300|AbsorbMP300|SpiritCombo100
  if (%job == RedMage) %abilities = Barrier300|Fire100|Thunder100|Blizzard100|Cure100|Sleep200|Poison100|Doublecast999|Catch300|MagicPow+300|RedCombo100
  if (%job == Summoner) %abilities = Unicorn200|Ifrit200|Ramuh200|Shiva200|Kirin200|Carbuncle300|Phoenix300|Madeen300|HalfMP300|SummonCombo100
  if (%job == Sniper) %abilities = Doubleshot300|BesoToxico200|DeathSickle300|Conceal100|DoomArcher300|Aim:Armor300|Aim:Weapon300|Aim:Wallet200|Auto-Regen300|SniperCombo100
  if (%job == Assassin) %abilities = Shadowbind200|LastBreath300|Aphonia200|Nightmare300|Ague200|Rockseal300|Oblivion300|UltimaMasher999|ReturnFire300|KillerCombo100
  if (%job == Alchemist) %abilities = Astra200|Death200|Meteor300|Rasp100|Flare300|Poison100|Toad200|MagicPow+300|Maintenance300|GoldCombo100
  if (%job == Sage) %abilities = Drain100|Blind100|Water200|Aero200|Raise300|GigaFlare300|Bio300|UltimaBlow999|Reflex300|WeaponDef+300|Shieldbearer300|WiseCombo100
  if (%job == Beastmaster) %abilities = Goblin200|Flan200|Bomb200|Dragon200|Lamia200|Bug200|Tonberry200|Panther200|Malboro200|Floateye200|Undead200|Fairy200|Rockbeast200|LastHaste300|Immunity300|BeastCombo100
  if (%job == Morpher) %abilities = Goblin200|Flan200|Bomb200|Dragon200|Lamia200|Bug200|Panther200|Malboro200|Floateye200|Damage>MP300|MorphCombo100
  if (%job == Warrior) %abilities = FirstAid100|Powerbreak200|Mindbreak200|Magicbreak200|Speedbreak200|BodySlam300|GreasedBolt300|Downsize300|MonkeyGrip300|Shieldbearer300|CombatCombo100
  if (%job == Dragoon) %abilities = Jump100|Lancet300|Wyrmtamer200|FireBreath300|BoltBreath300|IceBreath300|Wyrmkiller300|BangaaCry200|Dragonheart300|DragonCombo100
  if (%job == Defender) %abilities = Tremor100|Meltdown200|Defense200|DropWeapon200|Hibernate100|MowDown200|Aura300|ExpertGuard300|LastBerserk300|WeaponDef+300|DefendCombo100
  if (%job == Gladiator) %abilities = Rush100|WildSwing200|Beatdown200|Blitz200|FireSword200|BoltSword200|IceSword200|UltimaSword999|Strikeback300|Doublehand300|SwordCombo100
  if (%job == WhiteMonk) %abilities = Whirlwind100|AirRender200|EarthRender200|FarFist200|Chakra200|Revive300|Exorcise300|HolySign200|Reflex300|Counter300|MonkCombo100
  if (%job == Templar) %abilities = Astra200|Warcry300|Rasp100|Cheer100|Silence200|SoulSphere300|Haste200|Lifebreak300|Bonecrusher300|WeaponAtk+300|SacredCombo100
  if (%job == Bishop) %abilities = Cura200|Dispel200|Holy300|Barrier300|Judge300|Water200|Aero200|Break200|ReturnMagic300|HalfMP300|PrayCombo100
  if (%job == Hermetic) %abilities = Azoth0|Astra0|BlockArrows0|WeaponAtk+0
  if (%job == Runeseeker) %abilities = Explode0|Stillness0|Quarter0|Demi0|Counter0|WeaponDef+0
  if (%job == Judgemaster) %abilities = Abate0|JudgeSword0|Bind0|JPGift0|YellowClip0
  return %abilities
}
alias -l ffta.initini-abilities {
  var %job = $$1, %race = $2, %abilities = $ffta.abilsstr(%job), %z = 1, %clan = $ffta.getini(Clan, Clan), %numabils = $ffta.getini(%job, Abilities), %y = 1, %oldabillist, %newabillist, %oldhasap = $false
  if (%clan == ) %clan = 0
  if (%numabils == ) %numabils = 0
  while (%y <= %numabils) {
    var %ability = $ffta.getini(%job, Ability $+ %y)
    if (%ability == ) %ability = $null
    if ($numtok(%ability, 127) == 2) %oldhasap = $true
    %oldabillist = $addtok(%oldabillist, $gettok(%ability, 1, 127), 124)
    inc %y
  }
  %y = 1
  while (%y <= $numtok(%abilities, 124)) {
    var %ability = $gettok($gettok(%abilities, %y, 124), 1, 127)
    %newabillist = $addtok(%newabillist, %ability, 124)
    inc %y
  }
  if (%newabillist != %oldabillist) {
    if ((%job != Hermetic) && (%job != Runeseeker) && (%job != Judgemaster)) {
      while (%z <= %clan) {
        var %clanmember = $ffta.getini(Clan, Clan $+ %z), %clanrace = $ffta.getini(%clanmember, Race), %jobstr = $ffta.getini(%clanmember, %job), %newjobstr = $str(o, $numtok(%abilities, 124))
        if (%clanrace == %race) {
          if (%jobstr) {
            var %w = 1, %abils = $ffta.getini(%job, Abilities)
            if (%abils == ) %abils = 0
            while (%w <= %abils) {
              var %ability = $gettok($ffta.getini(%job, Ability $+ %w), 1, 127), %pos = $findtok(%abilities, $wildtok(%abilities, %ability $+ *, 1, 124), 1, 124)
              if (%pos) {
                var %before = $iif(%pos != 1, $mid(%newjobstr, 1, $calc(%pos - 1)))
                var %after = $iif(%pos != $len(%newjobstr), $mid(%newjobstr, $calc(%pos + 1), $calc($len(%newjobstr) - %pos)))
                var %mastered = $mid(%jobstr, %w, 1)
                %newjobstr = %before $+ %mastered $+ %after
              }
              inc %w
            }
          }
          ffta.putini %clanmember %job %newjobstr
        }
        inc %z
      }
    }
  }
  if ((%newabillist != %oldabillist) || (!%oldhasap)) {
    var %total = $numtok(%abilities, 124)
    ffta.putini %job Abilities %total
    %z = 1
    while (%z <= %total) {
      ffta.putini %job Ability $+ %z $gettok(%abilities, %z, 124)
      inc %z
    }
  }
}
alias -l ffta.initini {
  ffta.putini Version Version 2.2
  var %x = 1, %races = 5, %allraces = Human|Moogle|Viera|NuMou|Bangaa
  ffta.putini Races Races 5
  while (%x <= %races) {
    var %race = $gettok(%allraces, %x, 124), %jobs = $ffta.jobsstr(%race), %y = 1, %numjobs = $numtok(%jobs, 124)
    ffta.putini Races Race $+ %x %race
    ffta.putini %race Jobs %numjobs
    while (%y <= %numjobs) {
      var %job = $gettok(%jobs, %y, 124)
      ffta.putini %race Job $+ %y %job
      ffta.initini-abilities %job %race
      inc %y
    }
    inc %x
  }
  var %special = Hermetic|Runeseeker|Judgemaster
  %x = 1
  while (%x <= 3) {
    var %job = $gettok(%special, %x, 124)
    ffta.initini-abilities %job
    inc %x
  }
  dialog -x ffta.start-wait
  dialog -m ffta ffta
}
on *:DIALOG:ffta:INIT:*:{
  var %x = 1, %clan = $ffta.getini(Clan, Clan)
  if (%clan == ) %clan = 0
  while (%x <= %clan) {
    did -a ffta 5 $ffta.getini(Clan, Clan $+ %x)
    inc %x
  }
  did -i ffta 5 1 $null
  did -b ffta 7,8,11,14,16,17,18
  if (%clan == 24) did -b ffta 6
  if ((!%clan) || (%clan == 1)) did -b ffta 9
}
on *:DIALOG:ffta:EDIT:18:{
  var %clanmember = $did(5, $did(5, 1).sel), %job = $did(11, $did(11, 1).sel), %ability = $did(16, $did(16, 1).sel)
  if (($did(18) <= 0) || (!$did(18)) || ($did(18) !isnum)) did -o ffta 18 1 0
  if ($did(18) > $did(20)) did -o ffta 18 1 $did(20)
  did $iif($did(18) == $did(20), -e, -b) ffta 17
  if ($did(18)) ffta.putini %clanmember %job $+ $chr(124) $+ %ability $did(18)
  else ffta.remini %clanmember %job $+ $chr(124) $+ %ability
  if ($window(@ffta-report)) {
    var %y = $calc($fline(@ffta-report, %clanmember $+ *, 1) + 1), %lines = $line(@ffta-report, 0), %linenum = $sline(@ffta-report, 1).ln, %jobfound = $false
    while (%y <= %lines) {
      var %line = $line(@ffta-report, %y)
      if (Race* iswm $gettok(%line, 2, 9)) break
      if (Abilities* iswm $gettok(%line, 2, 9)) %jobfound = $iif( $+ %job $+ * iswm $gettok(%line, 1, 9), $true, $false)
      if (( $+ %ability $+ * iswm $gettok(%line, 1, 9)) && (%jobfound)) {
        rline @ffta-report %y  $+ %ability $+ $chr(9) $+ Learning: $did(18) / $did(20)
        break
      }
      inc %y
    }
    if (%linenum) sline @ffta-report %linenum
  }
}
on *:DIALOG:ffta:SCLICK:*:{
  if ($did == 5) {
    did -b ffta 14,16,17,18
    did -r ffta 11,16
    did -u ffta 14,17
    did -o ffta 18,20 1 $null
    if ($did(5, 1).sel == 1) {
      did -b ffta 7,8,11
      did -o ffta 10 1 $null
    }
    else {
      var %clanmember = $did(5, $did(5, 1).sel), %race = $iif(%clanmember == Ritz, Viera, $ffta.getini(%clanmember, Race))
      did $iif((%clanmember == Ezel) || (%clanmember == Babus) || (%clanmember == Cid), -b, -e) ffta 11
      did -o ffta 10 1 $iif(%clanmember == Ritz, Human, %race)
      did $iif((%clanmember == Ezel) || (%clanmember == Babus) || (%clanmember == Cid) || (%clanmember == Ritz) || (%clanmember == Shara) || (%clanmember == Marche) || (%clanmember == Montblanc), -b, -e) ffta 8
      if ((%clanmember == Ezel) || (%clanmember == Babus) || (%clanmember == Cid)) {
        did -e ffta 7,16
        var %job = $iif(%clanmember == Ezel, Hermetic, $iif(%clanmember == Babus, Runeseeker, Judgemaster))
        did -a ffta 11 %job
        did -c ffta 11 1
        var %abils = $ffta.getini(%job, Abilities), %x = 1
        if (%abils == ) %abils = 0
        while (%x <= %abils) {
          did -a ffta 16 $gettok($ffta.getini(%job, Ability $+ %x), 1, 127)
          inc %x
        }
        did -i ffta 16 1 $null
      }
      else {
        var %x = 1, %jobs = $ffta.getini(%race, Jobs)
        if (%jobs == ) %jobs = 0
        did $iif(%clanmember == Marche, -b, -e) ffta 7
        while (%x <= %jobs) {
          did -a ffta 11 $ffta.getini(%race, Job $+ %x)
          inc %x
        }
        did -i ffta 11 1 $null
      }
    }
  }
  if ($did == 11) {
    did -b ffta 14,17,18
    did -u ffta 14,17
    did -o ffta 18,20 1 $null
    did $iif($did(11, 1).sel == 1, -b, -e) ffta 16
    did -r ffta 16
    if ($did(11, 1).sel != 1) {
      var %x = 1, %job = $did(11, $did(11, 1).sel), %abilities = $ffta.getini(%job, Abilities)
      if (%abilities == ) %abilities = 0
      while (%x <= %abilities) {
        did -a ffta 16 $gettok($ffta.getini(%job, Ability $+ %x), 1, 127)
        inc %x
      }
      did -i ffta 16 1 $null
    }
  }
  if ($did == 16) {
    if ($did(16, 1).sel == 1) {
      did -b ffta 14,17,18
      did -u ffta 17
      did -o ffta 18,20 1 $null
    }
    else {
      var %clanmember = $did(5, $did(5, 1).sel), %job = $did(11, $did(11, 1).sel), %ability = $did(16, $did(16, 1).sel), %abilnum = $calc($did(16, 1).sel - 1), %jobstr = $ffta.getini(%clanmember, %job), %abil, %ap = $gettok($ffta.getini(%job, Ability $+ %abilnum), 2, 127), %charap = $ffta.getini(%clanmember, %job $+ $chr(124) $+ %ability)
      if (%charap == ) %charap = 0
      %abil = $mid(%jobstr, %abilnum, 1)
      if ((%clanmember != Ezel) && (%clanmember != Babus) && (%clanmember != Cid)) did $iif(((%charap == %ap) && (%abil == l)) || (!%ap) || ((%ap) && (%abil == x)), -e, -b) ffta 17
      did $iif((%ap) && (%abil != x), -e, -b) ffta 14
      did $iif(%abil == l, -e, -b) ffta 18
      did $iif(%abil == x, -c, -u) ffta 17
      did $iif(%abil == l, -c, -u) ffta 14
      if (%ap) {
        did -o ffta 20 1 %ap
        did -o ffta 18 1 $iif(%charap, %charap, $iif(%abil == x, %ap, 0))
      }
    }
  }
  if ($did == 14) {
    var %ability = $did(16, $did(16, 1).sel), %abilnum = $calc($did(16, 1).sel - 1), %clanmember = $did(5, $did(5, 1).sel), %job = $did(11, $did(11, 1).sel), %jobstr = $ffta.getini(%clanmember, %job), %newjobstr, %x = 1, %abils = $ffta.getini(%job, Abilities), %state = $did(14).state, %abilnum = $calc($did(16, 1).sel - 1), %ap = $gettok($ffta.getini(%job, Ability $+ %abilnum), 2, 127)
    if (%abils == ) %abils = 0
    did $iif(%state, -e, -b) ffta 18
    did $iif((%state) && (%ap == $did(18)), -e, -b) ffta 17
    while (%x <= $len(%jobstr)) {
      if (%x == %abilnum) %newjobstr = %newjobstr $+ $iif($did(14).state, l, $iif($did(18), p, o))
      else %newjobstr = %newjobstr $+ $mid(%jobstr, %x, 1)
      inc %x
    }
    if (%x <= %abils) %newjobstr = %newjobstr $+ $str(o, $calc(%abilnum - %x - 1)) $+ $iif($did(14).state, l, $iif($did(18), p, o)) $+ $str(o, $calc(%abils - %abilnum))
    ffta.putini %clanmember %job %newjobstr
    if ($window(@ffta-report)) {
      var %y = $calc($fline(@ffta-report, %clanmember $+ *, 1) + 1), %lines = $line(@ffta-report, 0), %linenum = $sline(@ffta-report, 1).ln, %jobfound = $false
      while (%y <= %lines) {
        var %line = $line(@ffta-report, %y)
        if (Race* iswm $gettok(%line, 2, 9)) break
        if (Abilities* iswm $gettok(%line, 2, 9)) %jobfound = $iif( $+ %job $+ * iswm $gettok(%line, 1, 9), $true, $false)
        if (( $+ %ability $+ * iswm $gettok(%line, 1, 9)) && (%jobfound)) {
          rline @ffta-report %y  $+ %ability $+ $chr(9) $+  $+ $iif($did(14).state, Learning: $did(18) / %ap, $iif($did(18), Partially Learned: $did(18) / %ap, Untrained))
          break
        }
        inc %y
      }
      if (%linenum) sline @ffta-report %linenum
    }
  }
  if ($did == 17) {
    var %ability = $did(16, $did(16, 1).sel), %abilnum = $calc($did(16, 1).sel - 1), %clanmember = $did(5, $did(5, 1).sel), %job = $did(11, $did(11, 1).sel), %jobstr = $ffta.getini(%clanmember, %job), %newjobstr, %x = 1, %abils = $ffta.getini(%job, Abilities), %ap = $gettok($ffta.getini(%job, Ability $+ %abilnum), 2, 127)
    if (%abils == ) %abils = 0
    while (%x <= $len(%jobstr)) {
      if (%x == %abilnum) %newjobstr = %newjobstr $+ $iif($did(17).state, x, $iif(%ap, l, o))
      else %newjobstr = %newjobstr $+ $mid(%jobstr, %x, 1)
      inc %x
    }
    if (%x <= %abils) %newjobstr = %newjobstr $+ $str(o, $calc(%abilnum - %x - 1)) $+ $iif($did(17).state, x, $iif(%ap, l, o)) $+ $str(o, $calc(%abils - %abilnum))
    ffta.putini %clanmember %job %newjobstr
    if (%ap) {
      did $iif($did(17).state, -b, -e) ffta 14,18
      did $iif($did(17).state, -u, -c) ffta 14
      if ($did(17).state) ffta.remini %clanmember %job $+ $chr(124) $+ %ability
      else ffta.putini %clanmember %job $+ $chr(124) $+ %ability %ap
    }
    if ($window(@ffta-report)) {
      var %y = $calc($fline(@ffta-report, %clanmember $+ *, 1) + 1), %lines = $line(@ffta-report, 0), %linenum = $sline(@ffta-report, 1).ln, %jobfound = $false, %origy = $calc(%y - 1)
      while (%y <= %lines) {
        var %line = $line(@ffta-report, %y)
        if (Race* iswm $gettok(%line, 2, 9)) break
        if (Abilities* iswm $gettok(%line, 2, 9)) {
          if ( $+ %job $+ * iswm $gettok(%line, 1, 9)) {
            var %abilsmastered = $gettok($gettok(%line, 2, 9), 3, 32), %abils = $gettok($gettok(%line, 2, 9), 5, 32)
            %abilsmastered = $calc(%abilsmastered + $iif($did(17).state, 1, -1))
            rline @ffta-report %y  $+ %job $+ $chr(9) $+ Abilities Mastered: %abilsmastered / %abils
            %jobfound = $true
          }
          else %jobfound = $false
        }
        if (( $+ %ability $+ * iswm $gettok(%line, 1, 9)) && (%jobfound)) {
          rline @ffta-report %y  $+ %ability $+ $chr(9) $+  $+ $iif($did(17).state, Mastered, $iif(%ap, Learning: %ap / %ap, Untrained))
          break
        }
        inc %y
      }
      var %line = $line(@ffta-report, %origy), %race = $ffta.getini(%clanmember, Race), %jobsmastered = 0, %jobs = $gettok($gettok(%line, 3, 9), 5, 32), %y = 1
      while (%y <= %jobs) {
        var %job = $ffta.getini(%race, Job $+ %y), %abils = $ffta.getini(%job, Abilities), %abilsmastered = 0, %jobstr = $ffta.getini(%clanmember, %job), %z = 1
        if (%abils == ) %abils = 0
        while (%z <= %abils) {
          if ($mid(%jobstr, %z, 1) == x) inc %abilsmastered
          inc %z
        }
        if (%abilsmastered == %abils) inc %jobsmastered
        inc %y
      }
      rline @ffta-report %origy %clanmember $+ $chr(9) $+ Race: %race $+ $chr(9) $+ Jobs Mastered: %jobsmastered / %jobs
      if (%linenum) sline @ffta-report %linenum
    }
  }
  if ($did == 6) {
    var %add = $dialog(ffta.additem, ffta.additem, -4)
    if (%add) {
      var %clan = $ffta.getini(Clan, Clan)
      if (%clan == ) %clan = 0
      ffta.putini Clan Clan $calc(%clan + 1)
      if (%fftatmp.insert <= %clan) {
        var %x = %clan
        while (%x >= %fftatmp.insert) {
          ffta.putini Clan Clan $+ $calc(%x + 1) $ffta.getini(Clan, Clan $+ %x)
          dec %x
        }
      }
      ffta.putini Clan Clan $+ %fftatmp.insert %fftatmp.name
      ffta.putini %fftatmp.name Race %fftatmp.race
      if ((%fftatmp.name == Ezel) || (%fftatmp.name == Babus) || (%fftatmp.name == Cid)) {
        if (%fftatmp.name == Ezel) ffta.putini Ezel Hermetic $str(x, 4)
        if (%fftatmp.name == Babus) ffta.putini Babus Runeseeker $str(x, 6)
        if (%fftatmp.name == Cid) ffta.putini Cid Judgemaster $str(x, 5)
      }
      else {
        var %y = 1, %race = $iif(%fftatmp.name == Ritz, Viera, %fftatmp.race), %jobs = $ffta.getini(%race, Jobs)
        if (%jobs == ) %jobs = 0
        while (%y <= %jobs) {
          var %job = $ffta.getini(%race, Job $+ %y), %ability = $ffta.getini(%job, Abilities)
          if (%ability == ) %ability = $null
          if (!%ability) { inc %y | continue }
          if (((%fftatmp.name == Ritz) && ((%job == Fencer) || (%job == Archer))) || ((%fftatmp.name == Shara) && (%job == Sniper)) || ((%fftatmp.name == Marche) && (%job == Soldier))) {
            var %z = 1, %abils = $ffta.getini(%job, Abilities), %jobstr, %abillist = $iif(%job == Fencer, Swarmstrike|Shadowstick|Featherblow|Manastrike|Piercethrough, $iif(%job == Archer, BlockArrows, $iif(%job == Sniper, DoomArcher|DeathSickle|Aim:Armor|Aim:Weapon|Auto-Regen, $iif(%job == Soldier, CombatCombat))))
            if (%abils == ) %abils = 0
            while (%z <= %abils) {
              var %abil = $gettok($ffta.getini(%job, Ability $+ %z), 1, 127), %abilch = o
              if ($findtok(%abillist, %abil, 0, 124)) %abilch = x
              %jobstr = %jobstr $+ %abilch
              inc %z
            }
            ffta.putini %fftatmp.name %job %jobstr
          }
          else ffta.putini %fftatmp.name %job $str(o, $ffta.getini(%job, Abilities))
          inc %y
        }
      }
      did -i ffta 5 $calc(%fftatmp.insert + 1) %fftatmp.name
      if ($ffta.getini(Clan, Clan) == 24) did -b ffta 6
      if (%clan == 1) did -e ffta 9
      if ($window(@ffta-report)) {
        var %x = 1, %lines = $line(@ffta-report, 0), %clanhit = 0
        while (%x <= %lines) {
          if (Race* iswm $gettok($line(@ffta-report, %x), 2, 9)) inc %clanhit
          if (%clanhit == %fftatmp.insert) {
            iline @ffta-report %x %fftatmp.name $+ $chr(9) $+ Race: %fftatmp.race
            break
          }
          inc %x
        }
        if (%x > %lines) aline @ffta-report %fftatmp.name $+ $chr(9) $+ Race: %fftatmp.race $chr(9) $+ Jobs Mastered: 0 / $ffta.getini(%fftatmp.race, Jobs)
      }
    }
    unset %fftatmp.*
  }
  if ($did == 7) {
    %fftatmp.type = clan
    var %rem = $dialog(ffta.remove, ffta.remove, -4)
    unset %fftatmp.type
    if (%rem) {
      var %x = $did(5, 1).sel, %clan = $ffta.getini(Clan, Clan)
      if (%clan == ) %clan = 0
      while (%x <= %clan) {
        ffta.putini Clan Clan $+ $calc(%x - 1) $ffta.getini(Clan, Clan $+ %x)
        inc %x
      }
      var %clanmember = $did(5, $did(5, 1).sel)
      ffta.remini Clan Clan $+ %clan
      ffta.remini %clanmember
      ffta.putini Clan Clan $calc(%clan - 1)
      if ($window(@ffta-report)) {
        var %x = $calc($fline(@ffta-report, %clanmember $+ *, 1) + 1), %lines = $line(@ffta-report, 0), %linestart = $calc(%x - 1), %lineend
        while (%x <= %lines) {
          if (Race* iswm $gettok($line(@ffta-report, %x), 2, 9)) break
          %lineend = %x
          inc %x
        }
        dline @ffta-report %linestart $+ $iif(%lineend, - $+ %lineend)
      }
      did -d ffta 5 $did(5, 1).sel
      did -b ffta 7,8,11,14,16,17,18, $+ $iif(%clan < 3, $chr(44) $+ 9)
      did -u ffta 14,17
      did -c ffta 5,11,16 1
      did -e ffta 6
      did -o ffta 10,18,20 1 $null
    }
  }
  if ($did == 23) fftareport
  if ($did == 24) var %tmp = $dialog(ffta.htmlcreate, ffta.htmlcreate, -4)
  if ($did == 8) {
    var %rename = $dialog(ffta.rename-box, ffta.rename-box, -4)
    if (%rename) ffta.rename $did(5, $did(5, 1).sel) %fftatmp.newname
    unset %fftatmp.newname
  }
  if ($did == 9) var %tmp = $dialog(ffta.reorder, ffta.reorder, -4)
}
dialog -l ffta.htmlcreate {
  title "HTML Creation"
  size -1 -1 67 41
  option dbu
  text "Select style:", 1, 5 5 57 7, center
  text "", 2, 5 14 57 7, hide center
  radio "1", 4, 16 13 15 10
  radio "2", 5, 36 13 15 10
  button "OK", 3, 6 26 25 10, default ok
  button "Cancel", 7, 36 26 25 10, cancel
  text "$false", 6, 0 0 0 0, hide
}
on *:DIALOG:ffta.htmlcreate:INIT:*:did -c $dname 4
on *:DIALOG:ffta.htmlcreate:SCLICK:3:{
  if (!$did(6)) {
    did -o $dname 1 1 Please
    did -o $dname 2 1 wait...
    did -o $dname 6 1 $true
    did -h $dname 4,5
    did -v $dname 2
    did -b $dname 3,7
    .timer 1 1 ffta.html-make $iif($did(4).state, 1, 2)
    halt
  }
}
alias ffta.htmldone {
  did -o ffta.htmlcreate 1 1 HTML file created!
  did -o ffta.htmlcreate 2 1 'ffta.html' in script's dir.
  did -e ffta.htmlcreate 3
}
alias fftareport {
  if ($window(@ffta-report)) window -c @ffta-report
  window -Cl -t20,34 @ffta-report -1 -1 500 500
  var %x = 1, %clan = $ffta.getini(Clan, Clan)
  if (%clan == ) %clan = 0
  while (%x <= %clan) {
    var %clanmember = $ffta.getini(Clan, Clan $+ %x), %race = $iif(%clanmember == Ritz, Viera, $ffta.getini(%clanmember, Race)), %jobs = $ffta.getini(%race, Jobs), %jobsmastered = 0, %y = 1
    if (%jobs == ) %jobs = 0
    if ((%clanmember == Ezel) || (%clanmember == Babus) || (%clanmember == Cid)) aline @ffta-report %clanmember $+ $chr(9) $+ Race: %race $+ $chr(9) $+ Jobs Mastered: 1 / 1
    else {
      while (%y <= %jobs) {
        var %job = $ffta.getini(%race, Job $+ %y), %abils = $ffta.getini(%job, Abilities), %abilsmastered = 0, %jobstr = $ffta.getini(%clanmember, %job), %z = 1
        if (%abils == ) %abils = 0
        while (%z <= %abils) {
          if ($mid(%jobstr, %z, 1) == x) inc %abilsmastered
          inc %z
        }
        if (%abilsmastered == %abils) inc %jobsmastered
        inc %y
      }
      aline @ffta-report %clanmember $+ $chr(9) $+ Race: $iif(%clanmember == Ritz, Human, %race) $+ $chr(9) $+ Jobs Mastered: %jobsmastered / %jobs
    }
    inc %x
  }
}
dialog -l ffta.additem {
  title "Add Clan Member"
  size -1 -1 130 69
  option dbu
  text "Add New Clan Member", 1, 5 6 56 7, right
  text "Clan Member's Race:", 2, 5 19 56 7, right
  edit "", 3, 64 5 61 10
  combo 4, 64 18 61 40, size drop
  text "Insert:", 5, 5 36 26 7, right
  radio "Before", 6, 36 31 25 10
  radio "After", 9, 36 41 25 10
  combo 10, 64 35 61 40, size drop
  button "OK", 7, 38 54 25 10, default ok
  button "Cancel", 8, 67 54 25 10, cancel
  text "", 11, 0 0 0 0, hide result
}
on *:DIALOG:ffta.additem:INIT:*:{
  var %x = 1, %races = $ffta.getini(Races, Races)
  if (%races == ) %races = 0
  while (%x <= %races) {
    did -a $dname 4 $ffta.getini(Races, Race $+ %x)
    inc %x
  }
  var %x = 1, %total = $ffta.getini(Clan, Clan)
  if (%total == ) %total = 0
  while (%x <= %total) {
    did -a $dname 10 $ffta.getini(Clan, Clan $+ %x)
    inc %x
  }
  if (%total > 0) {
    did -c $dname 10 %total
    did -c $dname 9
  }
  else did -b $dname 6,9,10
}
on *:DIALOG:ffta.additem:EDIT:3:{
  if (($did(3) == Ezel) || ($did(3) == Babus) || ($did(3) == Cid) || ($did(3) == Ritz) || ($did(3) == Shara) || ($did(3) == Marche) || ($did(3) == Montblanc)) {
    did -b $dname 4
    did -c $dname 4 $didwm(4, $iif(($did(3) == Ezel) || ($did(3) == Babus), NuMou, $iif(($did(3) == Cid) || ($did(3) == Ritz) || ($did(3) == Marche), Human, $iif($did(3) == Shara, Viera, Moogle))))
  }
  else did -e $dname 4
}
on *:DIALOG:ffta.additem:SCLICK:*:{
  if ($did == 8) did -o $dname 11 1 $false
  if ($did == 7) {
    if ((!$did(3)) || (!$did(4))) {
      if ((!$did(3)) && (!$did(4))) %fftatmp.error.needboth = $true
      if (!$did(3)) %fftatmp.error.need = name
      if (!$did(4)) %fftatmp.error.need = race
      var %tmp = $dialog(ffta.errorneed, ffta.errorneed, -4)
      unset %fftatmp.error.*
      halt
    }
    var %name = $replace($did(3), $chr(32), $chr(160))
    var %x = 1, %total = $ffta.getini(Clan, Clan)
    if (%total == ) %total = 0
    while (%x <= %total) {
      if (%name == $ffta.getini(Clan, Clan $+ %x)) {
        %fftatmp.error.name = %name
        var %tmp = $dialog(ffta.errorexist, ffta.errorexist, -4)
        unset %fftatmp.error.*
        halt
      }
      inc %x
    }
    var %y = 1, %races = $ffta.getini(Races, Races)
    if (%races == ) %races = 0
    while (%y <= %races) {
      var %race = $ffta.getini(Races, Race $+ %y), %z = 1, %jobs = $ffta.getini(%race, Jobs)
      if (%jobs == ) %jobs = 0
      if (%name == %race) {
        %fftatmp.error.name = %name
        %fftatmp.error.else = $true
        var %tmp = $dialog(ffta.errorexist, ffta.errorexist, -4)
        unset %fftatmp.error.*
        halt
      }
      while (%z <= %jobs) {
        var %job = $ffta.getini(%race, Job $+ %z)
        if (%name == %job) {
          %fftatmp.error.name = %name
          %fftatmp.error.else = $true
          var %tmp = $dialog(ffta.errorexist, ffta.errorexist, -4)
          unset %fftatmp.error.*
          halt
        }
        inc %z
      }
      inc %y
    }
    did -o $dname 11 1 $true
    %fftatmp.name = %name
    %fftatmp.race = $did(4, $did(4, 1).sel)
    %fftatmp.insert = $iif(%total > 0, $calc($did(10, 1).sel + $iif($did(6).state, 0, 1)), 1)
  }
}
dialog -l ffta.remove {
  title "Remove Clan Member"
  size -1 -1 91 46
  option dbu
  text "Are you sure you want to remove", 1, 5 5 81 7, center
  text "", 2, 5 13 81 7, center
  text "from the clan?", 3, 5 21 81 7, center
  button "OK", 4, 16 31 25 10, default ok
  button "Cancel", 5, 45 31 25 10, cancel
  text "", 6, 0 0 0 0, hide result
}
on *:DIALOG:ffta.remove:INIT:*:did -o $dname 2 1 ' $+ $did(ffta, 5, $did(ffta, 5, 1).sel) $+ '
on *:DIALOG:ffta.remove:SCLICK:*:did -o $dname 6 1 $iif($did == 4, $true, $iif($did == 5, $false))
dialog -l ffta.errorneed {
  title "ERROR!"
  size -1 -1 76 38
  option dbu
  text "", 1, 5 5 66 7, center
  text "", 2, 5 13 66 7, center
  button "OK", 3, 28 23 20 10, default cancel
}
on *:DIALOG:ffta.errorneed:INIT:*:{
  did -o $dname 1 1 You must enter $+ $iif(%fftatmp.error.needboth, $chr(32) $+ both)
  did -o $dname 2 1 $iif(%fftatmp.error.need == name || %fftatmp.error.needboth, name) $+ $iif(%fftatmp.error.needboth, $chr(32) $+ and $+ $chr(32)) $+ $iif(%fftatmp.error.need == race || %fftatmp.error.needboth, race) to continue!
}
dialog -l ffta.errorexist {
  title "ERROR!"
  size -1 -1 72 38
  option dbu
  text "", 1, 5 5 62 7, center
  text "already exists!", 2, 5 13 62 7, center
  button "OK", 3, 26 23 20 10, default cancel
}
on *:DIALOG:ffta.errorexist:INIT:*:{
  did -o $dname 1 1 ' $+ %fftatmp.error.name $+ '
  if (%fftatmp.error.else) did -o $dname 2 1 already exists elsewhere!
}
dialog -l ffta.rename-box {
  title "Rename Clan Member"
  size -1 -1 93 43
  option dbu
  text "", 1, 5 5 83 7
  text "New Name:", 2, 5 16 28 7
  edit "", 3, 38 15 50 10
  button "OK", 4, 19 28 25 10, disable ok
  button "Cancel", 5, 49 28 25 10, default cancel
  text "", 6, 0 0 0 0, hide result
}
on *:DIALOG:ffta.rename-box:INIT:*:{
  var %oldname = $did(ffta, 5, $did(ffta, 5, 1).sel)
  did -o $dname 1 1 Renaming: ' $+ %oldname $+ '
  did -o $dname 3 1 %oldname
}
on *:DIALOG:ffta.rename-box:EDIT:3:{
  var %oldname = $did(ffta, 5, $did(ffta, 5, 1).sel)
  if ($did(3) == %oldname) {
    did -b $dname 4
    did -t $dname 5
  }
  else did -et $dname 4
}
on *:DIALOG:ffta.rename-box:SCLICK:*:{
  did -o $dname 6 1 $iif($did == 4, $true, $iif($did == 5, $false))
  if ($did == 4) %fftatmp.newname = $replace($did(3), $chr(32), $chr(160))
}
dialog -l ffta.reorder {
  title "Reorder Clan Members"
  size -1 -1 100 73
  option dbu
  list 1, 5 5 50 49, size
  button "Move Up", 2, 58 11 35 10
  button "Move Down", 3, 58 25 35 10
  button "Reset", 4, 58 38 35 10
  button "OK", 5, 23 58 25 10, ok
  button "Cancel", 6, 52 58 25 10, default cancel
  list 7, 0 0 0 0, hide size
}
on *:DIALOG:ffta.reorder:INIT:*:{
  var %lines = $did(ffta, 5).lines, %x = 2
  while (%x <= %lines) {
    var %name = $did(ffta, 5, %x)
    did -a $dname 1,7 %name
    inc %x
  }
  did -b $dname 2,3,4,5
}
on *:DIALOG:ffta.reorder:SCLICK:*:{
  var %lines = $did(1).lines
  if ($did == 1) {
    did $iif($did(1, 1).sel != 1, -e, -b) $dname 2
    did $iif($did(1, 1).sel != %lines, -e, -b) $dname 3
  }
  if (($did == 2) || ($did == 3)) {
    var %didline = $did(1, 1).sel, %name = $did(1, %didline)
    did -d $dname 1 %didline
    $iif($did == 2, dec, inc) %didline
    did -i $dname 1 %didline %name
    did -c $dname 1 %didline
    if (%didline == $iif($did == 2, 1, %lines)) did -b $dname $did
    if (%didline != $iif($did == 2, 1, %lines)) did -e $dname $iif($did == 2, 3, 2)
    var %x = 1, %same = $true
    while (%x <= %lines) {
      if ($did(1, %x) != $did(7, %x)) {
        %same = $false
        break
      }
      inc %x
    }
    did $iif(%same, -b, -e) $dname 4,5
    did -t $dname $iif(%same, 6, 5)
  }
  if ($did == 4) {
    did -r $dname 1
    var %x = 1
    while (%x <= %lines) {
      did -a $dname 1 $did(7, %x)
      inc %x
    }
    did -b $dname 2,3,4,5
    did -t $dname 6
  }
  if ($did == 5) {
    ffta.do-reorder
    halt
  }
}
alias -l ffta-report.menu.check-mastery {
  var %line = $sline(@ffta-report, 1), %linenum = $sline(@ffta-report, 1).ln, %x = $calc(%linenum - 1)
  while (%x >= 0) {
    if (Race* iswm $gettok($line(@ffta-report, %x), 2, 9)) {
      %clanmember = $gettok($line(@ffta-report, %x), 1, 9)
      break
    }
    dec %x
  }
  if ((%clanmember == Ezel) || (%clanmember == Babus) || (%clanmember == Cid)) return $false
  if ((Mastered* iswm $gettok($sline(@ffta-report, 1), 2, 9)) || ((Learning* iswm $gettok($sline(@ffta-report, 1), 2, 9)) && ($gettok($gettok($sline(@ffta-report, 1), 2, 9), 2, 32) == $gettok($gettok($sline(@ffta-report, 1), 2, 9), 4, 32)))) return $true
  if (Untrained* iswm $gettok($sline(@ffta-report, 1), 2, 9)) {
    var %linenum = $sline(@ffta-report, 1).ln, %job, %x = $calc(%linenum - 1), %jobline, %joblinenum, %ability = $mid($gettok($sline(@ffta-report, 1), 1, 9), 3)
    while (%x >= 0) {
      if (Abilities* iswm $gettok($line(@ffta-report, %x), 2, 9)) {
        %job = $mid($gettok($line(@ffta-report, %x), 1, 9), 2)
        %jobline = $line(@ffta-report, %x)
        %joblinenum = %x
        break
      }
      dec %x
    }
    if (!%job) return $false
    %x = 0
    var %abilnum, %abils = $ffta.getini(%job, Abilities)
    if (%abils == ) %abils = 0
    while (%x <= %abils) {
      var %abil = $gettok($ffta.getini(%job, Ability $+ %x), 1, 127)
      if (%abil == %ability) { %abilnum = %x | break }
      inc %x
    }
    return $iif($gettok($ffta.getini(%job, Ability $+ %abilnum), 2, 127), $false, $true)
  }
  return $false
}
alias -l ffta-report.menu.check-learning {
  if ((Partially Learned* iswm $gettok($sline(@ffta-report, 1), 2, 9)) || (Learning* iswm $gettok($sline(@ffta-report, 1), 2, 9))) return $true
  if (Untrained* iswm $gettok($sline(@ffta-report, 1), 2, 9)) {
    var %line = $sline(@ffta-report, 1), %linenum = $sline(@ffta-report, 1).ln, %job, %x = $calc(%linenum - 1), %jobline, %joblinenum, %ability = $mid($gettok($sline(@ffta-report, 1), 1, 9), 3)
    while (%x >= 0) {
      if (Abilities* iswm $gettok($line(@ffta-report, %x), 2, 9)) {
        %job = $mid($gettok($line(@ffta-report, %x), 1, 9), 2)
        %jobline = $line(@ffta-report, %x)
        %joblinenum = %x
        break
      }
      dec %x
    }
    if (!%job) return $false
    %x = 0
    var %abilnum, %abils = $ffta.getini(%job, Abilities)
    if (%abils == ) %abils = 0
    while (%x <= %abils) {
      var %abil = $gettok($ffta.getini(%job, Ability $+ %x), 1, 127)
      if (%abil == %ability) { %abilnum = %x | break }
      inc %x
    }
    return $iif($gettok($ffta.getini(%job, Ability $+ %abilnum), 2, 127), $true, $false)
  }
  return $false
}
menu @ffta-report {
  $iif(Race* iswm $gettok($sline(@ffta-report, 1), 2, 9), $iif(Abilities* iswm $gettok($line(@ffta-report, $calc($sline(@ffta-report, 1).ln + 1)), 2, 9), Shrink, Expand) Jobs):ffta.report-job
  $iif(Abilities* iswm $gettok($sline(@ffta-report, 1), 2, 9), $iif((Mastered* iswm $gettok($line(@ffta-report, $calc($sline(@ffta-report, 1).ln + 1)), 2, 9)) || (Learning* iswm $gettok($line(@ffta-report, $calc($sline(@ffta-report, 1).ln + 1)), 2, 9)) || (Partially* iswm $gettok($line(@ffta-report, $calc($sline(@ffta-report, 1).ln + 1)), 2, 9)) || (Untrained* iswm $gettok($line(@ffta-report, $calc($sline(@ffta-report, 1).ln + 1)), 2, 9)), Shrink, Expand) Abilities):ffta.report-abil
  $iif($ffta-report.menu.check-mastery, Toggle Mastery):ffta.report-toggle.master
  $iif($ffta-report.menu.check-learning, Toggle Learning):ffta.report-toggle.learn
  $iif(Learning* iswm $gettok($sline(@ffta-report, 1), 2, 9), Set AP):ffta.report.set-ap
  $iif($dialog(ffta), Jump to Selected):ffta.report-jumpto
}
dialog -l ffta.ap-set {
  title "Set AP"
  size -1 -1 68 43
  option dbu
  text "", 1, 5 5 58 7
  text "AP:", 2, 5 16 9 7
  edit "", 3, 17 15 17 10, limit 3 right
  text "/", 4, 35 16 2 7
  edit "", 5, 38 15 17 10, read right
  button "OK", 6, 5 28 25 10, ok
  button "Cancel", 7, 35 28 25 10, cancel
  text "", 8, 0 0 0 0, hide result
}
on *:DIALOG:ffta.ap-set:INIT:*:{
  var %clanmember = %fftatmp.clan, %job = %fftatmp.job, %ability = %fftatmp.abil
  var %x = 0, %abilnum, %abils = $ffta.getini(%job, Abilities)
  if (%abils == ) %abils = 0
  while (%x <= %abils) {
    var %abil = $gettok($ffta.getini(%job, Ability $+ %x), 1, 127)
    if (%abil == %ability) { %abilnum = %x | break }
    inc %x
  }
  did -o $dname 1 1 Ability: ' $+ %ability $+ '
  var %charap = $ffta.getini(%clanmember, %job $+ $chr(124) $+ %ability), %ap = $gettok($ffta.getini(%job, Ability $+ %abilnum), 2, 127)
  if (%charap == ) %charap = 0
  did -o $dname 3 1 %charap
  did -o $dname 5 1 %ap
}
on *:DIALOG:ffta.ap-set:EDIT:3:{
  var %clanmember = %fftatmp.clan, %job = %fftatmp.job, %ability = %fftatmp.abil
  if (($did(3) <= 0) || (!$did(3)) || ($did(3) !isnum)) did -o $dname 3 1 0
  if ($did(3) > $did(5)) did -o $dname 3 1 $did(5)
}
on *:DIALOG:ffta.ap-set:SCLICK:*:{
  did -o $dname 8 1 $iif($did == 6, $true, $iif($did == 7, $false))
  if ($did == 6) %fftatmp.newap = $did(3)
}
alias -l ffta.report.set-ap {
  var %line = $sline(@ffta-report, 1), %linenum = $sline(@ffta-report, 1).ln, %clanmember, %job, %jobfound = $false, %x = $calc(%linenum - 1), %jobline, %joblinenum
  while (%x >= 0) {
    if ((Abilities* iswm $gettok($line(@ffta-report, %x), 2, 9)) && (!%jobfound)) {
      %job = $mid($gettok($line(@ffta-report, %x), 1, 9), 2)
      %jobline = $line(@ffta-report, %x)
      %joblinenum = %x
      %jobfound = $true
    }
    if (Race* iswm $gettok($line(@ffta-report, %x), 2, 9)) {
      %clanmember = $gettok($line(@ffta-report, %x), 1, 9)
      break
    }
    dec %x
  }
  if ((!%clanmember) || (!%job)) break
  %fftatmp.clan = %clanmember
  %fftatmp.job = %job
  %fftatmp.abil = $mid($gettok(%line, 1, 9), 3)
  var %y = 0, %abilnum, %abils = $ffta.getini(%job, Abilities)
  if (%abils == ) %abils = 0
  while (%y <= %abils) {
    var %abil = $gettok($ffta.getini(%job, Ability $+ %y), 1, 127)
    if (%abil == %fftatmp.abil) { %abilnum = %y | break }
    inc %y
  }
  var %chg = $dialog(ffta.ap-set, ffta.ap-set, -3), %ap = $gettok($ffta.getini(%job, Ability $+ %abilnum), 2, 127)
  if (%chg) {
    if (%fftatmp.newap) ffta.putini %clanmember %job $+ $chr(124) $+ %fftatmp.abil %fftatmp.newap
    else ffta.remini %clanmember %job $+ $chr(124) $+ %fftatmp.abil
    var %jobstr = $ffta.getini(%clanmember, %job)
    var %strabil = $mid(%jobstr, %abilnum, 1)
    if ((%strabil == p) && (!%fftatmp.newap)) {
      var %newjobstr = %jobstr
      var %before = $iif(%abilnum != 1, $mid(%newjobstr, 1, $calc(%abilnum - 1)))
      var %after = $iif(%abilnum != $len(%newjobstr), $mid(%newjobstr, $calc(%abilnum + 1), $calc($len(%newjobstr) - %abilnum)))
      %newjobstr = %before $+ o $+ %after
      ffta.putini %clanmember %job %newjobstr
      %strabil = o
    }
    %line = $puttok(%line,  $+ $iif(%strabil == l, Learning: %fftatmp.newap / %ap, $iif(%strabil == p, Partially Learned: %fftatmp.newap / %ap, Untrained)), 2, 9)
    rline @ffta-report %linenum %line
    sline @ffta-report %linenum
    if ($dialog(ffta)) {
      if (($did(ffta, 5, $did(ffta, 5, 1).sel) == %clanmember) && ($did(ffta, 11, $did(ffta, 11, 1).sel) == %job) && ($did(ffta, 16, $did(ffta, 16, 1).sel) == %fftatmp.abil)) {
        did -o ffta 18 1 %fftatmp.newap
        if (%abil == o) did -u ffta 14
        did $iif(%fftatmp.newap == %ap, -e, -b) ffta 17
      }
    }
  }
  unset %fftatmp.*
}
alias -l ffta.report-job {
  if (Abilities* iswm $gettok($line(@ffta-report, $calc($sline(@ffta-report, 1).ln + 1)), 2, 9)) {
    var %x = $calc($sline(@ffta-report, 1).ln + 1), %lines = $line(@ffta-report, 0), %linestart = %x, %lineend
    while (%x <= %lines) {
      if (Race* iswm $gettok($line(@ffta-report, %x), 2, 9)) break
      %lineend = %x
      inc %x
    }
    dline @ffta-report %linestart $+ $iif(%lineend, - $+ %lineend)
  }
  else {
    var %x = $calc($sline(@ffta-report, 1).ln + 1), %clanmember = $gettok($sline(@ffta-report, 1), 1, 9), %race = $iif(%clanmember == Ritz, Viera, $ffta.getini(%clanmember, Race)), %y = 1, %jobs = $ffta.getini(%race, Jobs)
    if (%jobs == ) %jobs = 0
    if ((%clanmember == Ezel) || (%clanmember == Babus) || (%clanmember == Cid)) {
      var %job = $iif(%clanmember == Ezel, Hermetic, $iif(%clanmember == Babus, Runeseeker, Judgemaster)), %abils = $ffta.getini(%job, Abilities)
      if (%abils == ) %abils = 0
      iline @ffta-report %x  $+ %job $+ $chr(9) $+ Abilities Mastered: %abils / %abils
    }
    else {
      while (%y <= %jobs) {
        var %job = $ffta.getini(%race, Job $+ %y), %abils = $ffta.getini(%job, Abilities), %abilsmastered = 0, %jobstr = $ffta.getini(%clanmember, %job), %z = 1
        if (%abils == ) %abils = 0
        while (%z <= %abils) {
          if ($mid(%jobstr, %z, 1) == x) inc %abilsmastered
          inc %z
        }
        iline @ffta-report %x  $+ %job $+ $chr(9) $+ Abilities Mastered: %abilsmastered / %abils
        inc %x
        inc %y
      }
    }
  }
}
alias -l ffta.report-abil {
  if ((Mastered* iswm $gettok($line(@ffta-report, $calc($sline(@ffta-report, 1).ln + 1)), 2, 9)) || (Learning* iswm $gettok($line(@ffta-report, $calc($sline(@ffta-report, 1).ln + 1)), 2, 9)) || (Partially* iswm $gettok($line(@ffta-report, $calc($sline(@ffta-report, 1).ln + 1)), 2, 9)) || (Untrained* iswm $gettok($line(@ffta-report, $calc($sline(@ffta-report, 1).ln + 1)), 2, 9))) {
    var %x = $calc($sline(@ffta-report, 1).ln + 1), %lines = $line(@ffta-report, 0), %linestart = %x, %lineend
    while (%x <= %lines) {
      if ((Race* iswm $gettok($line(@ffta-report, %x), 2, 9)) || (Abilities* iswm $gettok($line(@ffta-report, %x), 2, 9))) break
      %lineend = %x
      inc %x
    }
    dline @ffta-report %linestart $+ $iif(%lineend, - $+ %lineend)
  }
  else {
    var %x = $calc($sline(@ffta-report, 1).ln + 1), %clanmember, %y = $calc(%x - 2)
    while (%y >= 0) {
      if (Race* iswm $gettok($line(@ffta-report, %y), 2, 9)) {
        %clanmember = $gettok($line(@ffta-report, %y), 1, 9)
        break
      }
      dec %y
    }
    if (!%clanmember) return
    var %job = $mid($gettok($sline(@ffta-report, 1), 1, 9), 2), %abils = $ffta.getini(%job, Abilities), %abilsmastered = 0, %jobstr = $ffta.getini(%clanmember, %job), %z = 1
    if (%abils == ) %abils = 0
    while (%z <= %abils) {
      var %abilstr = $ffta.getini(%job, Ability $+ %z), %abil = $gettok(%abilstr, 1, 127), %ap = $gettok(%abilstr, 2, 127), %charap = $ffta.getini(%clanmember, %job $+ $chr(124) $+ %abil)
      if (%charap == ) %charap = 0
      iline @ffta-report %x  $+ %abil $+ $chr(9) $+  $+ $iif($mid(%jobstr, %z, 1) == x, Mastered, $iif($mid(%jobstr, %z, 1) == l, Learning: $iif(%charap, %charap, 0) / %ap, $iif($mid(%jobstr, %z, 1) == p, Partially Learned: %charap / %ap, Untrained)))
      inc %x
      inc %z
    }
  }
}
alias -l ffta.report-toggle.master {
  var %line = $sline(@ffta-report, 1), %linenum = $sline(@ffta-report, 1).ln, %clanmember, %job, %jobfound = $false, %x = $calc(%linenum - 1), %jobline, %joblinenum, %clanline, %clanlinenum
  while (%x >= 0) {
    if ((Abilities* iswm $gettok($line(@ffta-report, %x), 2, 9)) && (!%jobfound)) {
      %job = $mid($gettok($line(@ffta-report, %x), 1, 9), 2)
      %jobline = $line(@ffta-report, %x)
      %joblinenum = %x
      %jobfound = $true
    }
    if (Race* iswm $gettok($line(@ffta-report, %x), 2, 9)) {
      %clanmember = $gettok($line(@ffta-report, %x), 1, 9)
      %clanline = $line(@ffta-report, %x)
      %clanlinenum = %x
      break
    }
    dec %x
  }
  if ((!%clanmember) || (!%job)) return
  var %ability = $mid($gettok(%line, 1, 9), 3), %abilnum, %jobstr = $ffta.getini(%clanmember, %job), %abil, %y = 1, %abilities = $ffta.getini(%job, Abilities), %newjobstr = %jobstr, %ap
  if (%abilities == ) %abilities = 0
  while (%y <= %abilities) {
    var %abil2 = $gettok($ffta.getini(%job, Ability $+ %y), 1, 127)
    if (%abil2 == %ability) {
      %abilnum = %y
      break
    }
    inc %y
  }
  %abil = $mid(%jobstr, %abilnum, 1)
  %ap = $gettok($ffta.getini(%job, Ability $+ %abilnum), 2, 127)
  %abil = $iif(%abil == x, $iif(%ap, l, o), x)
  if ($len(%newjobstr) < %abilities) %newjobstr = %newjobstr $+ $str(o, $calc(%abilities - $len(%newjobstr)))
  var %before = $iif(%abilnum != 1, $mid(%newjobstr, 1, $calc(%abilnum - 1)))
  var %after = $iif(%abilnum != $len(%newjobstr), $mid(%newjobstr, $calc(%abilnum + 1), $calc($len(%newjobstr) - %abilnum)))
  %newjobstr = %before $+ %abil $+ %after
  ffta.putini %clanmember %job %newjobstr
  if (%abil == x) ffta.remini %clanmember %job $+ $chr(124) $+ %ability
  else ffta.putini %clanmember %job $+ $chr(124) $+ %ability %ap
  %line = $puttok(%line,  $+ $iif(%abil == x, Mastered, $iif(%ap, Learning: %ap / %ap, Untrained)), 2, 9)
  rline @ffta-report %linenum %line
  sline @ffta-report %linenum
  var %abilsmastered = $gettok($gettok(%jobline, 2, 9), 3, 32), %abils = $gettok($gettok(%jobline, 2, 9), 5, 32)
  $iif(%abil == x, inc, dec) %abilsmastered
  %jobline = $puttok(%jobline, Abilities Mastered: %abilsmastered / %abils, 2, 9)
  rline @ffta-report %joblinenum %jobline
  var %jobsmastered = 0, %jobs = $gettok($gettok(%clanline, 3, 9), 5, 32), %race = $gettok($gettok(%clanline, 2, 9), 2, 32)
  %y = 1
  while (%y <= %jobs) {
    var %job = $ffta.getini(%race, Job $+ %y), %abils = $ffta.getini(%job, Abilities), %abilsmastered = 0, %jobstr = $ffta.getini(%clanmember, %job), %z = 1
    if (%abils == ) %abils = 0
    while (%z <= %abils) {
      if ($mid(%jobstr, %z, 1) == x) inc %abilsmastered
      inc %z
    }
    if (%abilsmastered == %abils) inc %jobsmastered
    inc %y
  }
  %clanline = $puttok(%clanline, Jobs Mastered: %jobsmastered / %jobs, 3, 9)
  rline @ffta-report %clanlinenum %clanline
  if ($dialog(ffta)) {
    if (($did(ffta, 5, $did(ffta, 5, 1).sel) == %clanmember) && ($did(ffta, 11, $did(ffta, 11, 1).sel) == %job) && ($did(ffta, 16, $did(ffta, 16, 1).sel) == %ability)) {
      did $iif(%abil == x, -c, -u) ffta 17
      if (%ap) did $iif(%abil == x, -ub, -ce) ffta 14,18
    }
  }
}
alias -l ffta.report-toggle.learn {
  var %line = $sline(@ffta-report, 1), %linenum = $sline(@ffta-report, 1).ln, %clanmember, %job, %jobfound = $false, %x = $calc(%linenum - 1), %jobline, %joblinenum
  while (%x >= 0) {
    if ((Abilities* iswm $gettok($line(@ffta-report, %x), 2, 9)) && (!%jobfound)) {
      %job = $mid($gettok($line(@ffta-report, %x), 1, 9), 2)
      %jobline = $line(@ffta-report, %x)
      %joblinenum = %x
      %jobfound = $true
    }
    if (Race* iswm $gettok($line(@ffta-report, %x), 2, 9)) {
      %clanmember = $gettok($line(@ffta-report, %x), 1, 9)
      break
    }
    dec %x
  }
  if ((!%clanmember) || (!%job)) return
  var %ability = $mid($gettok(%line, 1, 9), 3), %abilnum, %jobstr = $ffta.getini(%clanmember, %job), %abil, %y = 1, %abilities = $ffta.getini(%job, Abilities), %newjobstr = %jobstr, %ap, %charap
  if (%abilities == ) %abilities = 0
  while (%y <= %abilities) {
    var %abil2 = $gettok($ffta.getini(%job, Ability $+ %y), 1, 127)
    if (%abil2 == %ability) {
      %abilnum = %y
      break
    }
    inc %y
  }
  %abil = $mid(%jobstr, %abilnum, 1)
  %ap = $gettok($ffta.getini(%job, Ability $+ %abilnum), 2, 127)
  %charap = $ffta.getini(%clanmember, %job $+ $chr(124) $+ %ability)
  if (%charap == ) %charap = 0
  %abil = $iif(%abil == l, $iif(%charap, p, o), l)
  if ($len(%newjobstr) < %abilities) %newjobstr = %newjobstr $+ $str(o, $calc(%abilities - $len(%newjobstr)))
  var %before = $iif(%abilnum != 1, $mid(%newjobstr, 1, $calc(%abilnum - 1)))
  var %after = $iif(%abilnum != $len(%newjobstr), $mid(%newjobstr, $calc(%abilnum + 1), $calc($len(%newjobstr) - %abilnum)))
  %newjobstr = %before $+ %abil $+ %after
  ffta.putini %clanmember %job %newjobstr
  if ((%abil == o) && (!%charap)) ffta.remini %clanmember %job $+ $chr(124) $+ %ability
  else ffta.putini %clanmember %job $+ $chr(124) $+ %ability %charap
  %line = $puttok(%line,  $+ $iif(%abil == l, Learning: %charap / %ap, $iif(%abil == p, Partially Learned: %charap / %ap, Untrained)), 2, 9)
  rline @ffta-report %linenum %line
  sline @ffta-report %linenum
  if ($dialog(ffta)) {
    if (($did(ffta, 5, $did(ffta, 5, 1).sel) == %clanmember) && ($did(ffta, 11, $did(ffta, 11, 1).sel) == %job) && ($did(ffta, 16, $did(ffta, 16, 1).sel) == %ability)) {
      did $iif(%abil == l, -c, -u) ffta 14
      did $iif(%abil == l, -e, -b) ffta 18
      did $iif((%abil == l) && (%charap == %ap), -e, -b) ffta 17
    }
  }
}
alias -l ffta.report-jumpto {
  var %line = $sline(@ffta-report, 1), %linenum = $sline(@ffta-report, 1).ln
  did -b ffta 7,8,11,14,16,17,18
  did -u ffta 14,17
  did -o ffta 18,20 1 $null
  if (Race* iswm $gettok(%line, 2, 9)) {
    var %clanmember = $gettok(%line, 1, 9)
    ffta.jump-to.setup-dialog %clanmember
  }
  if (Abilities* iswm $gettok(%line, 2, 9)) {
    var %clanmember, %x = $calc(%linenum - 1)
    while (%x >= 0) {
      if (Race* iswm $gettok($line(@ffta-report, %x), 2, 9)) {
        %clanmember = $gettok($line(@ffta-report, %x), 1, 9)
        break
      }
      dec %x
    }
    if (!%clanmember) return
    var %job = $mid($gettok(%line, 1, 9), 2)
    did -e ffta 16
    ffta.jump-to.setup-dialog %clanmember %job
  }
  if ((Mastered* iswm $gettok(%line, 2, 9)) || (Learning* iswm $gettok(%line, 2, 9)) || (Partially* iswm $gettok(%line, 2, 9)) || (Untrained* iswm $gettok(%line, 2, 9))) {
    var %clanmember, %job, %jobfound = $false, %x = $calc(%linenum - 1)
    while (%x >= 0) {
      if ((Abilities* iswm $gettok($line(@ffta-report, %x), 2, 9)) && (!%jobfound)) {
        %job = $mid($gettok($line(@ffta-report, %x), 1, 9), 2)
        %jobfound = $true
      }
      if (Race* iswm $gettok($line(@ffta-report, %x), 2, 9)) {
        %clanmember = $gettok($line(@ffta-report, %x), 1, 9)
        break
      }
      dec %x
    }
    if ((!%clanmember) || (!%job)) return
    did -e ffta 16
    ffta.jump-to.setup-dialog %clanmember %job
    var %ability = $mid($gettok(%line, 1, 9), 3), %abilnum = $didwm(ffta, 16, %ability), %jobstr = $ffta.getini(%clanmember, %job), %abil, %ap, %charap
    did -c ffta 16 %abilnum
    dec %abilnum
    %abil = $mid(%jobstr, %abilnum, 1)
    %ap = $gettok($ffta.getini(%job, Ability $+ %abilnum), 2, 127)
    %charap = $ffta.getini(%clanmember, %job $+ $chr(124) $+ %ability)
    if (%charap == ) %charap = 0
    if ((%clanmember != Ezel) && (%clanmember != Babus) && (%clanmember != Cid) && (((%charap == %ap) && (%abil == l)) || (!%ap) || ((%ap) && (%abil == x)))) did -e ffta 17
    if ((%ap) && (%abil != x)) did -e ffta 14 $+ $iif(%abil == l, $chr(44) $+ 18)
    if (%abil == x) did -c ffta 17
    if (%abil == l) did -c ffta 14
    if (%ap) {
      did -o ffta 20 1 %ap
      did -o ffta 18 1 $iif(%charap, %charap, $iif(%abil == x, %ap, 0))
    }
  }
}
alias -l ffta.jump-to.setup-dialog {
  var %clanmember = $$1, %job = $2
  did -r ffta 11,16
  var %race = $iif(%clanmember == Ritz, Viera, $ffta.getini(%clanmember, Race))
  did -c ffta 5 $didwm(ffta, 5, %clanmember)
  did $iif((%clanmember == Ezel) || (%clanmember == Babus) || (%clanmember == Cid), -b, -e) ffta 11
  did -o ffta 10 1 $iif(%clanmember == Ritz, Human, %race)
  did $iif((%clanmember == Ezel) || (%clanmember == Babus) || (%clanmember == Cid) || (%clanmember == Ritz) || (%clanmember == Shara) || (%clanmember == Marche) || (%clanmember == Montblanc), -b, -e) ffta 8
  if ((%clanmember == Ezel) || (%clanmember == Babus) || (%clanmember == Cid)) {
    did -e ffta 7
    var %job = $iif(%clanmember == Ezel, Hermetic, $iif(%clanmember == Babus, Runeseeker, Judgemaster))
    did -a ffta 11 %job
    did -c ffta 11 1
    var %abils = $ffta.getini(%job, Abilities), %x = 1
    if (%abils == ) %abils = 0
    while (%x <= %abils) {
      did -a ffta 16 $gettok($ffta.getini(%job, Ability $+ %x), 1, 127)
      inc %x
    }
    did -i ffta 16 1 $null
    did -e ffta 16
  }
  else {
    var %x = 1, %jobs = $ffta.getini(%race, Jobs)
    if (%jobs == ) %jobs = 0
    did $iif(%clanmember == Marche, -b, -e) ffta 7
    while (%x <= %jobs) {
      did -a ffta 11 $ffta.getini(%race, Job $+ %x)
      inc %x
    }
    did -i ffta 11 1 $null
    if (%job) {
      var %abilities = $ffta.getini(%job, Abilities)
      if (%abilities == ) %abilities = 0
      did -c ffta 11 $didwm(ffta, 11, %job)
      %x = 1
      while (%x <= %abilities) {
        did -a ffta 16 $gettok($ffta.getini(%job, Ability $+ %x), 1, 127)
        inc %x
      }
      did -i ffta 16 1 $null
    }
  }
}
on *:LOAD:{
  echo 12 -a CyberBotX's FFTA Clan Ability Manager v2.2 has been installed.  Please look in your status window for more information.
  echo 12 -s Usage: To open the Ability Manager dialog, either use the command '/ffta' or right-click in any window and select 'FFTA Clan Ability Manager' from the FFTA menu option.
  echo 12 -s The usage after that should be self explanitory.
  echo 12 -s To open the Report window without opening the dialog box, either use the command'/fftareport' or right-click in any window and select 'FFTA Clan Ability Report' from the FFTA menu option.
  echo 12 -s Inside the Report window, right-clicking on a clan member or a job will give you the option to expand/shrink that option.  Right-clicking on an ability will give you the option to change if it's been trained or not.  Also right-clicking on any of those will let you jump to that option in the dialog, if it's open.
  echo 6 -s Comments, Questions, Concerns?  Send me an e-mail at: cyberbotx@peacefulhaven.net  Also look for me in #theWorld on irc2.magicstar.net or #cbx-anims on irc2.peacefulhaven.net
  echo 14 -a FFTA Clan Ability Manager v2.2 is 2003-2005 Naram Qashat a.k.a. CyberBotX.
}
on *:UNLOAD:{
  echo 12 -a Thank you for using CyberBotX's FFTA Clan Ability Manager v2.2.
  echo 14 -a FFTA Clan Ability Manager v2.2 is 2003-2005 Naram Qashat a.k.a. CyberBotX.
}
menu channel,status,nicklist,query,menubar {
  -
  FFTA
  . $+ $iif(!$dialog(ffta), FFTA Clan Abilities Manager):ffta
  .FFTA Clan Abilities Report:fftareport
}
alias ffta.html-make {
  var %style = $$1, %version = $version, %cmd = $iif(6.1* iswm $version, .fwrite -n ffta.html, write " $+ $fftadir $+ ffta.html")
  $iif(6.1* iswm $version, .fopen -o ffta.html, write -c) " $+ $fftadir $+ ffta.html"
  %cmd <!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
  %cmd <html>
  %cmd <head>
  %cmd <title>FFTA Ability Report</title>
  %cmd <meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">
  %cmd <style type="text/css">
  %cmd <!--
  %cmd body $chr(123) font-family: Ariel, sans-serif; text-align: left; $chr(125)
  %cmd .hide $chr(123) display: none; visibility: hidden; $chr(125)
  %cmd tbody, tr, td $chr(123) padding: inherit; border: inherit; $chr(125)
  %cmd table.typea $chr(123) border: 1px #000 solid; padding: 0; border-collapse: collapse; $chr(125)
  if (%style == 2) %cmd table.typeb $chr(123) border: 1px #FFF solid; padding: 0; border-collapse: collapse; $chr(125)
  %cmd .cella $chr(123) background: #FFF; color: #000; border: inherit; padding: 5px; $chr(125)
  if (%style == 2) %cmd .cellb $chr(123) background: #000; color: #FFF; border: inherit; padding: 5px; $chr(125)
  if (%style == 1) %cmd ul $chr(123) margin-top: 0; margin-bottom: 0; $chr(125)
  %cmd table.center $chr(123) margin: auto; $chr(125)
  if (%style == 2) %cmd .padding $chr(123) padding: 5px; $chr(125)
  if (%style == 1) %cmd .mediumtext $chr(123) font-size: medium; $chr(125)
  %cmd .largetext $chr(123) font-size: large; $chr(125)
  %cmd .xlargetext $chr(123) font-size: x-large; $chr(125)
  %cmd -->
  %cmd </style>
  %cmd <script type="text/javascript">
  %cmd <!--
  %cmd function toggle_display(toggle, self, type) $chr(123)
  %cmd toggleb = document.getElementById(toggle);
  var %display = $iif(%style == 1, block, table-row)
  %cmd disp = toggleb.style.display == ' $+ %display $+ ' ? 'none' : ' $+ %display $+ ';
  %cmd toggleb.style.display = disp;
  %cmd toggleb.style.visibility = toggleb.style.visibility == 'visible' ? 'hidden' : 'visible';
  %cmd self.value = (disp == 'none' ? 'Show' : 'Hide') + ' ' + type;
  %cmd $chr(125)
  %cmd // -->
  %cmd </script>
  %cmd </head>
  %cmd <body>
  %cmd <table class="center typea">
  %cmd <tr><td style="text-align: center" class="cella" $+ $iif(%style == 2, $chr(32) $+ colspan="3") $+ >FFTA Ability Report</td></tr>
  var %x = 1, %clan = $ffta.getini(Clan, Clan)
  if (%clan == ) %clan = 0
  while (%x <= %clan) {
    var %clanmember = $ffta.getini(Clan, Clan $+ %x), %race = $iif(%clanmember == Ritz, Viera, $ffta.getini(%clanmember, Race)), %jobs = $ffta.getini(%race, Jobs), %jobsmastered = 0, %y = 1
    if (%jobs == ) %jobs = 0
    if ((%clanmember != Ezel) && (%clanmember != Babus) && (%clanmember != Cid)) {
      while (%y <= %jobs) {
        var %job = $ffta.getini(%race, Job $+ %y), %abils = $ffta.getini(%job, Abilities), %abilsmastered = 0, %jobstr = $ffta.getini(%clanmember, %job), %z = 1
        if (%abils == ) %abils = 0
        while (%z <= %abils) {
          if ($mid(%jobstr, %z, 1) == x) inc %abilsmastered
          inc %z
        }
        if (%abilsmastered == %abils) inc %jobsmastered
        inc %y
      }
    }
    if (%style == 1) {
      %cmd <tr><td class="cella xlargetext"><ul>
      %cmd <li> $+ %clanmember --- Race: $iif(%clanmember == Ritz, Human, %race) --- Jobs Mastered: $iif((%clanmember == Ezel) || (%clanmember == Babus) || (%clanmember == Cid), 1 / 1, %jobsmastered / %jobs) <input type="button" value="Show Jobs" onClick="toggle_display('c $+ %x $+ ', this, 'Jobs')">
      %cmd <div class="hide" id="c $+ %x $+ "><ul class="largetext">
    }
    if (%style == 2) {
      %cmd <tr class="cella xlargetext"><td> $+ %clanmember $+ </td><td>Race: $iif(%clanmember == Ritz, Human, %race) $+ </td><td>Jobs Mastered: $iif((%clanmember == Ezel) || (%clanmember == Babus) || (%clanmember == Cid), 1 / 1, %jobsmastered / %jobs) <input type="button" value="Show Jobs" onClick="toggle_display('c $+ %x $+ ', this, 'Jobs')"></td></tr>
      %cmd <tr class="hide" id="c $+ %x $+ "><td colspan="3" class="padding"><table class="center typeb">
    }
    var %y = 1, %jobs = $ffta.getini(%race, Jobs)
    if (%jobs == ) %jobs = 0
    if ((%clanmember == Ezel) || (%clanmember == Babus) || (%clanmember == Cid)) {
      var %job = $iif(%clanmember == Ezel, Hermetic, $iif(%clanmember == Babus, Runeseeker, Judgemaster)), %abils = $ffta.getini(%job, Abilities)
      if (%abils == ) %abils = 0
      if (%style == 1) {
        %cmd <li> $+ %job --- Abilities Mastered: %abils / %abils <input type="button" value="Show Abilities" onClick="toggle_display('c $+ %x $+ j $+ %y $+ ', this, 'Abilities')">
        %cmd <div class="hide" id="c $+ %x $+ j $+ %y $+ "><ul class="mediumtext">
      }
      if (%style == 2) {
        %cmd <tr class="cellb largetext"><td> $+ %job $+ </td>
        %cmd <td>Abilities Mastered: %abils / %abils <input type="button" value="Show Abilities" onClick="toggle_display('c $+ %x $+ j $+ %y $+ ', this, 'Abilities')"></td></tr>
        %cmd <tr class="hide cellb" id="c $+ %x $+ j $+ %y $+ "><td colspan="2"><table class="center typea">
      }
      var %z = 1
      while (%z <= %abils) {
        var %abil = $gettok($ffta.getini(%job, Ability $+ %z), 1, 127)
        if (%style == 1) %cmd <li> $+ %abil --- Mastered
        if (%style == 2) {
          %cmd <tr class="cella"><td> $+ %abil $+ </td>
          %cmd <td>Mastered</td></tr>
        }
        inc %z
      }
      if (%style == 1) %cmd </ul></div>
      if (%style == 2) %cmd </table></td></tr>
    }
    else {
      while (%y <= %jobs) {
        var %job = $ffta.getini(%race, Job $+ %y), %abils = $ffta.getini(%job, Abilities), %abilsmastered = 0, %jobstr = $ffta.getini(%clanmember, %job), %z = 1
        if (%abils == ) %abils = 0
        while (%z <= %abils) {
          if ($mid(%jobstr, %z, 1) == x) inc %abilsmastered
          inc %z
        }
        if (%style == 1) {
          %cmd <li> $+ %job --- Abilities Mastered: %abilsmastered / %abils <input type="button" value="Show Abilities" onClick="toggle_display('c $+ %x $+ j $+ %y $+ ', this, 'Abilities')">
          %cmd <div class="hide" id="c $+ %x $+ j $+ %y $+ "><ul class="mediumtext">
        }
        if (%style == 2) {
          %cmd <tr class="cellb largetext"><td> $+ %job $+ </td>
          %cmd <td>Abilities Mastered: %abilsmastered / %abils <input type="button" value="Show Abilities" onClick="toggle_display('c $+ %x $+ j $+ %y $+ ', this, 'Abilities')"></td></tr>
          %cmd <tr class="hide cellb" id="c $+ %x $+ j $+ %y $+ "><td colspan="2"><table class="center typea">
        }
        %z = 1
        while (%z <= %abils) {
          var %abilstr = $ffta.getini(%job, Ability $+ %z), %abil = $gettok(%abilstr, 1, 127), %ap = $gettok(%abilstr, 2, 127), %charap = $ffta.getini(%clanmember, %job $+ $chr(124) $+ %abil)
          if (%charap == ) %charap = 0
          if (%style == 1) %cmd <li> $+ %abil --- $iif($mid(%jobstr, %z, 1) == x, Mastered, $iif($mid(%jobstr, %z, 1) == l, Learning: %charap / %ap, $iif($mid(%jobstr, %z, 1) == p, Partially Learned: %charap / %ap, Untrained)))
          if (%style == 2) {
            %cmd <tr class="cella"><td> $+ %abil $+ </td>
            %cmd <td> $+ $iif($mid(%jobstr, %z, 1) == x, Mastered, $iif($mid(%jobstr, %z, 1) == l, Learning: %charap / %ap, $iif($mid(%jobstr, %z, 1) == p, Partially Learned: %charap / %ap, Untrained))) $+ </td></tr>
          }
          inc %z
        }
        if (%style == 1) %cmd </ul></div>
        if (%style == 2) %cmd </table></td></tr>
        inc %y
      }
    }
    if (%style == 1) %cmd </ul></div></ul></td></tr>
    if (%style == 2) %cmd </table></td></tr>
    inc %x
  }
  %cmd </table>
  %cmd </body>
  $iif(6.1* iswm $version, .fwrite ffta.html, write -n " $+ $fftadir $+ ffta.html") </html>
  if (6.1* iswm $version) .fclose ffta.html
  ffta.htmldone
}
alias -l ffta.rename {
  var %oldname = $$1, %newname = $$2
  var %x = 1, %clan = $ffta.getini(Clan, Clan), %lines
  if (%clan == ) %clan = 0
  while (%x <= %clan) {
    var %clanmember = $ffta.getini(Clan, Clan $+ %x)
    if (%clanmember == %oldname) {
      ffta.putini Clan Clan $+ %x %newname
      break
    }
    inc %x
  }
  did -r ffta 25
  loadbuf -ot $+ %oldname ffta 25 ffta.ini
  %x = 1
  %lines = $did(ffta, 25).lines
  while (%x <= %lines) {
    var %line = $did(ffta, 25, %x)
    ffta.putini %newname $gettok(%line, 1, 61) $gettok(%line, 2, 61)
    inc %x
  }
  ffta.remini %oldname
  var %didline = $didwm(ffta, 5, %oldname)
  did -o ffta 5 %didline %newname
  did -c ffta 5 %didline
  if ($window(@ffta-report)) {
    var %linenum = $fline(@ffta-report, %oldname $+ *, 1), %line = $line(@ffta-report, %linenum)
    %line = $puttok(%line, %newname, 1, 9)
    rline @ffta-report %linenum %line
  }
}
alias -l ffta.do-reorder {
  var %names = $did(ffta.reorder, 1).lines, %x = 1
  var %didline = $did(ffta, 5, 1).sel, %didname = $did(ffta, 5, %didline)
  did -r ffta 5
  var %exstr = $left($str(s|, %names), -1)
  while (%x <= %names) {
    var %name = $did(ffta.reorder, 1, %x)
    ffta.putini Clan Clan $+ %x %name
    did -a ffta 5 %name
    %exstr = $ffta.reorder.makeex(%exstr, %name, %x)
    inc %x
  }
  did -i ffta 5 1 $null
  did -c ffta 5 $iif(%didname, $didwm(ffta, 5, %didname), 1)
  ffta.reorder.rewrite-report %exstr
  dialog -x ffta.reorder
}
alias -l ffta.reorder.makeex {
  var %exstr = $$1, %name = $$2, %x = $$3
  if ($window(@ffta-report)) {
    var %linenum = $fline(@ffta-report, %name $+ *, 1), %line1 = $line(@ffta-report, %linenum), %line2 = $line(@ffta-report, $calc(%linenum + 1)), %lines = $line(@ffta-report, 0), %y = %linenum, %z = 1
    if (Abilities* iswm $gettok(%line2, 2, 9)) {
      var %race = $iif(%name == Ritz, Viera, $gettok($gettok(%line1, 2, 9), 2, 32)), %jobs = $iif((%name == Ezel) || (%name == Babus) || (%name == Cid), 1, $ffta.getini(%race, Jobs))
      %exstr = $puttok(%exstr, $str(o, %jobs), %x, 124)
      var %str2 = $str(o, %jobs)
      while (%y <= %lines) {
        %line1 = $line(@ffta-report, %y)
        %line2 = $line(@ffta-report, $calc(%y + 1))
        if (Abilities* iswm $gettok(%line1, 2, 9)) {
          if ((Mastered* iswm $gettok(%line2, 2, 9)) || (Learning* iswm $gettok(%line2, 2, 9)) || (Partially* iswm $gettok(%line2, 2, 9)) || (Untrained* iswm $gettok(%line2, 2, 9))) {
            var %newstr, %before, %after
            %before = $iif(%z != 1, $mid(%str2, 1, $calc(%z - 1)))
            %after = $iif(%z != $len(%str2), $mid(%str2, $calc(%z + 1), $calc($len(%str2) - %z)))
            %newstr = %before $+ x $+ %after
            %exstr = $puttok(%exstr, %newstr, %x, 124)
            %str2 = %newstr
          }
          if (Race* iswm $gettok(%line2, 2, 9)) break
          inc %z
        }
        inc %y
      }
    }
  }
  return %exstr
}
alias -l ffta.reorder.rewrite-report {
  var %exstr = $$1, %names = $ffta.getini(Clan, Clan)
  if (%names == ) %names = 0
  if ($window(@ffta-report)) {
    var %x = 1
    dline @ffta-report 1- $+ $line(@ffta-report, 0)
    while (%x <= %names) {
      var %name = $ffta.getini(Clan, Clan $+ %x), %race = $iif(%name == Ritz, Viera, $ffta.getini(%name, Race)), %jobs = $ffta.getini(%race, Jobs), %jobsmastered = 0, %y = 1
      if (%jobs == ) %jobs = 0
      while (%y <= %jobs) {
        var %job = $ffta.getini(%race, Job $+ %y), %abils = $ffta.getini(%job, Abilities), %abilsmastered = 0, %jobstr = $ffta.getini(%name, %job), %z = 1
        if (%abils == ) %abils = 0
        while (%z <= %abils) {
          if ($mid(%jobstr, %z, 1) == x) inc %abilsmastered
          inc %z
        }
        if (%abilsmastered == %abils) inc %jobsmastered
        inc %y
      }
      aline @ffta-report %name $+ $chr(9) $+ Race: $iif(%name == Ritz, Human, %race) $+ $chr(9) $+ Jobs Mastered: %jobsmastered / %jobs
      var %str2 = $gettok(%exstr, %x, 124)
      if (%str2 != s) {
        if ((%name == Ezel) || (%name == Babus) || (%name == Cid)) {
          var %job = $iif(%name == Ezel, Hermetic, $iif(%name == Babus, Runeseeker, Judgemaster)), %abils = $ffta.getini(%job, Abilities)
          if (%abils == ) %abils = 0
          aline @ffta-report  $+ %job $+ $chr(9) $+ Abilities Mastered: %abils / %abils
          if (%str2 == x) {
            var %y = 1
            while (%y <= %abils) {
              var %abil = $gettok($ffta.getini(%job, Ability $+ %y), 1, 127)
              aline @ffta-report  $+ %abil $+ $chr(9) $+ Mastered
              inc %y
            }
          }
        }
        else {
          var %jobs = $ffta.getini(%race, Jobs), %y = 1
          if (%jobs == ) %jobs = 0
          while (%y <= %jobs) {
            var %job = $ffta.getini(%race, Job $+ %y), %abils = $ffta.getini(%job, Abilities), %abilsmastered = 0, %jobstr = $ffta.getini(%name, %job), %z = 1
            if (%abils == ) %abils = 0
            while (%z <= %abils) {
              if ($mid(%jobstr, %z, 1) == x) inc %abilsmastered
              inc %z
            }
            aline @ffta-report  $+ %job $+ $chr(9) $+ Abilities Mastered: %abilsmastered / %abils
            if ($mid(%str2, %y, 1) == x) {
              %z = 1
              while (%z <= %abils) {
                var %abilstr = $ffta.getini(%job, Ability $+ %z), %abil = $gettok(%abilstr, 1, 127), %ap = $gettok(%abilstr, 2, 127), %charap = $ffta.getini(%clanmember, %job $+ $chr(124) $+ %abil)
                if (%charap == ) %charap = 0
                aline @ffta-report  $+ %abil $+ $chr(9) $+  $+ $iif($mid(%jobstr, %z, 1) == x, Mastered, $iif($mid(%jobstr, %z, 1) == l, Learning: %charap / %ap, $iif($mid(%jobstr, %z, 1) == p, Partially Learned: %charap / %ap, Untrained)))
                inc %z
              }
            }
            inc %y
          }
        }
      }
      inc %x
    }
  }
}